/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/  

/**
 * \file    ioexpander.c
 *
 * \brief   Utility Routine for testing the GPIO Expander
 *
 * This file contains the utility routines for testing the GPIO Expander
 * on the DM814X EVM.
 *
 * \author  0043
 *
 * \version 01a,25aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_types.h"
#include "DM814x_EVM.h"
#include "DM814x_i2c.h"
#include "ioexpander.h"
#include "stdio.h"

/** **************************************************************************
 * \n \brief Routine to test the GPIO expander
 *
 * This routine tests the IOexpander .It tests by changing the states
 * of input and output pins of IOexpander pins.
 * 
 * 
 * \return
 * \n      return SUCCESS on successful completion of the routine
 * 
 */
STATUS ioexpander_test( )
{
	STATUS u32RetVal = SUCCESS;
    INT16 i,j;
    UINT8 state = 0;

	/* initialize the I2C controller */
    u32RetVal = DM814xI2cInit ( GPIO_EXP_I2C_BUS_NUM );
  	
	/* Get switch pattern */
    u32RetVal = sw_get( &state );
	
	if (SUCCESS == u32RetVal )
	{
		printf("The state of the switches are %x\n", state );
	}
	else
	{
		printf ("Error reading the switch status.\r\n");
		return (u32RetVal);
	}

	/* Manipulate User LEDs */
	printf("Displaying LED patterns...\n ");
	
	for(i=0;i<8;i++)
        {
	    u32RetVal = led_set_pat(0x05 );
	    
	    DM814x_usecDelay (1000000);
        
        u32RetVal = led_set_pat(0x0A );
	    DM814x_usecDelay (1000000);
        
        if (u32RetVal == FAILED)
        {
        	printf ("Failed to set the LED status.\r\n");
        	return (u32RetVal); 
        }
	}
	u32RetVal = led_set_pat(0x00 );
	
	state = 0;
    state = ~state & 0x01;

       for(j=0;j<4;j++)
       {
            u32RetVal = led_set_num(j,state);
	    	DM814x_usecDelay (1000000);
       }
	
       u32RetVal  = led_set_pat(0x0F );
 
   return u32RetVal ;
}

